import { createClient } from '@supabase/supabase-js';
import dotenv from 'dotenv';

dotenv.config();

// Validate required environment variables
const requiredEnvVars = ['SUPABASE_URL', 'SUPABASE_ANON_KEY', 'SUPABASE_SERVICE_ROLE_KEY'];
for (const envVar of requiredEnvVars) {
  if (!process.env[envVar]) {
    throw new Error(`Missing required environment variable: ${envVar}`);
  }
}

// Create Supabase client with anon key (for client-side operations)
export const supabase = createClient(
  process.env.SUPABASE_URL!,
  process.env.SUPABASE_ANON_KEY!
);

// Create Supabase client with service role key (for admin operations)
export const supabaseAdmin = createClient(
  process.env.SUPABASE_URL!,
  process.env.SUPABASE_SERVICE_ROLE_KEY!
);

// Database table names
export const TABLES = {
  USERS: 'users',
  VENDORS: 'vendors',
  CUSTOMERS: 'customers',
  SUBSCRIPTIONS: 'subscriptions',
  INVOICES: 'invoices',
  ORDERS: 'orders',
  PRODUCTS: 'products',
  MEASUREMENTS: 'measurements',
  NOTIFICATIONS: 'notifications',
  // Subscriptions module tables
  SUBSCRIPTION_PLANS: 'subscription_plans',
  VENDOR_SUBSCRIPTIONS: 'vendor_subscriptions',
  FEATURES: 'features',
  SUBSCRIPTION_PLAN_FEATURES: 'subscription_plan_features',
  TRIAL_SETTINGS: 'trial_settings',
  WITHDRAWALS: 'withdrawals',
  TRANSACTIONS: 'transactions', // Used by invoices and withdrawals
  PAYOUTS: 'payouts',
  PAYMENT_GATEWAYS: 'payment_gateways',
  // Consultation module tables
  CONSULTATION_FORMS: 'consultation_forms',
  CONSULTATION_QUESTIONS: 'consultation_questions',
  CONSULTATION_RESPONSES: 'consultation_responses',
  // Seller Management module tables
  SELLERS: 'sellers',
  SELLER_INVENTORY: 'seller_inventory',
  SELLER_ORDERS: 'seller_orders',
  // Debug module tables
  AI_LOGS: 'ai_logs',
  DEBUG_LOGS: 'debug_logs',
} as const;

// User roles
export const USER_ROLES = {
  VENDOR: 'vendor',
  ADMIN: 'admin',
  STAFF: 'staff',
  SUPER_ADMIN: 'superadmin'
} as const;

// Onboarding status
export const ONBOARDING_STATUS = {
  INCOMPLETE: 'incomplete',
  COMPLETE: 'complete'
} as const;

export type UserRole = typeof USER_ROLES[keyof typeof USER_ROLES];
export type OnboardingStatus = typeof ONBOARDING_STATUS[keyof typeof ONBOARDING_STATUS]; 